/*
 * Decompiled with CFR 0.152.
 */
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DynamicScopes {
    static boolean useDynamicScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Context context = Context.enter();
        try {
            String string = "var x = 'sharedScope';\nfunction f() { return x; }\nfunction initClosure(prefix) {\n    return function test() { return prefix+x; }\n}\nvar closure = initClosure('nested:');\n";
            Script script = context.compileString(string, "sharedScript", 1, null);
            useDynamicScope = false;
            DynamicScopes.runScripts(context, script);
            useDynamicScope = true;
            DynamicScopes.runScripts(context, script);
        }
        finally {
            Context.exit();
        }
    }

    static void runScripts(Context context, Script script) {
        int n;
        ScriptableObject scriptableObject = context.initStandardObjects(null, true);
        script.exec(context, (Scriptable)scriptableObject);
        Thread[] threadArray = new Thread[3];
        for (n = 0; n < 3; ++n) {
            String string = "function g() { var x = 'local'; return f(); }\njava.lang.System.out.println(g());\nfunction g2() { var x = 'local'; return closure(); }\njava.lang.System.out.println(g2());\n";
            threadArray[n] = new Thread(new PerThread((Scriptable)scriptableObject, string, "thread" + n));
        }
        for (n = 0; n < 3; ++n) {
            threadArray[n].start();
        }
        for (n = 0; n < 3; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        ContextFactory.initGlobal((ContextFactory)new MyFactory());
    }

    static class PerThread
    implements Runnable {
        private Scriptable sharedScope;
        private String source;
        private String x;

        PerThread(Scriptable scriptable, String string, String string2) {
            this.sharedScope = scriptable;
            this.source = string;
            this.x = string2;
        }

        @Override
        public void run() {
            Context context = Context.enter();
            try {
                Scriptable scriptable = context.newObject(this.sharedScope);
                scriptable.setPrototype(this.sharedScope);
                scriptable.setParentScope(null);
                scriptable.put("x", scriptable, (Object)this.x);
                context.evaluateString(scriptable, this.source, "threadScript", 1, null);
            }
            finally {
                Context.exit();
            }
        }
    }

    static class MyFactory
    extends ContextFactory {
        MyFactory() {
        }

        protected boolean hasFeature(Context context, int n) {
            if (n == 7) {
                return useDynamicScope;
            }
            return super.hasFeature(context, n);
        }
    }
}

